/* ============ */
/* tstbjcof.c	*/
/* ============ */
#include <stdlib.h>
#include <stdio.h>
#include <miscdefs.h>
#include <defcodes.h>
#include <assert.h>
int	Variates[10003];
double	CorrCoef[10000];
int	CoefCtrs[201];
/* ==================================================================== */
/*		    Main Program to Test Function BJCoef		*/
/* ==================================================================== */
void
main()
{
    AbortGracefully();			/* Make ^C act reasonably */

    while (main)
    {
	int	k;
	int	CallStatus;
	int	NumCoefs, NumVariates;

	GetInt("How Many Coefficients? [4 <= N <= 10000]: ", &NumCoefs);

	if (NumCoefs < 3 || NumCoefs > 10000)
	{
	    NumCoefs = 625;
	}

	NumVariates = NumCoefs + 3;

	for (k = 0; k < NumVariates; ++k)
	{
	    Variates[k] = rand();
	}

	CallStatus = BJCoef(Variates, NumVariates, CorrCoef, NumCoefs);
	if (CallStatus == OK)
	{
	    double  MaxCoef = -1, MinCoef = 1,
		    Mean = 0, StdDev, Variance = 0;
	    for (k = 0; k < NumCoefs; ++k)
	    {
		P(CorrCoef[k] *= 2);
		Mean += CorrCoef[k];
		P(fprintf(stderr, "%4d:%+24.15e\n", k+1, CorrCoef[k]));
	    }
	    Mean /= (double)NumCoefs;

	    for (k = 0; k < NumCoefs; ++k)
	    {
		Variance += SQR(CorrCoef[k] - Mean);
	    }
	    Variance = 1.0/((double)NumCoefs-1) * Variance;

	    fprintf(stderr, "\nFor %d Coefficients from BJCoef():\n"
		   "\tActual Mean    = %+.10f, Actual Variance    = %+.10f\n",
			NumCoefs, Mean, Variance);
	    Mean = -1.0/((double)NumCoefs-1);
	    StdDev = -Mean *
		sqrt((double)NumCoefs * ((double)NumCoefs-3) /
			((double)NumCoefs+1));
	    fprintf(stderr,
		   "\tTheoretic Mean = %+.10f, Theoretic Variance = %+.10f\n",
			Mean, StdDev*StdDev);
	for (k = 0; k < NumCoefs; ++k)
	{
	    int    PctIdx = (int)(100. * (10*CorrCoef[k] + 1.0));
	    MaxCoef = __max(MaxCoef, CorrCoef[k]);
	    MinCoef = __min(MinCoef, CorrCoef[k]);
if (PctIdx < 0 || PctIdx > 200)
{
	printf("At k = %5d, PctIdx = %d\n", k, PctIdx);
}
	    assert(PctIdx >= 0 && PctIdx <= 200);
	    ++CoefCtrs[PctIdx];
	}
	for (k = 0; k < 201; ++k)
	{
	    P(printf("%3d\t%5d\n", k, CoefCtrs[k]));
	}
	fprintf(stderr, "%+.11e  Maximum Correlation Coefficient\n",
		MaxCoef);
	fprintf(stderr, "%+.11e  Minimum Correlation Coefficient\n",
		MinCoef);
exit(1);
	}
	else
	{
	    printf("Error incurred in BJCoef()\n");
	}
    }
}
# endif

